﻿using Hims.Shared.UserModels.NurseShift;
using System;

namespace Hims.Api.Helper
{
    public static class ProgressReportHelper
    {
        /// <summary>
        /// Gets the current day identifier.
        /// </summary>
        /// <returns></returns>
        public static int GetCurrentDayId()
        {
            var currentHour = DateTime.Now.Hour;

            // 1 = Morning
            // 11 = After Morning Before Afternoon
            // 2 = Afternoon
            // 12 = After Afternoon before Night
            // 3 = Night
            // 4 = After Night
            var currentDayId = currentHour < 6 
                ? 0 
                : currentHour >= 6 && currentHour <= 9
                    ? 1
                    : currentHour > 9 && currentHour < 12
                        ? 11
                        : currentHour >= 12 && currentHour <= 14
                        ? 2
                        : currentHour > 14 && currentHour < 19
                            ? 12
                            : currentHour >= 19 && currentHour <= 21
                                ? 3
                                : 4;
            return currentDayId;
        }

        /// <summary>
        /// Gets the current day identifier.
        /// </summary>
        /// <returns></returns>
        public static double GetCurrentDayIdAlt()
        {
            var currentHour = DateTime.Now.Hour;

            // 1 = Morning
            // 11 = After Morning Before Afternoon
            // 2 = Afternoon
            // 12 = After Afternoon before Night
            // 3 = Night
            // 4 = After Night
            var currentDayId = currentHour < 6
                ? 0
                : currentHour >= 6 && currentHour <= 9
                    ? 1
                    : currentHour > 9 && currentHour < 12
                        ? 1.1
                        : currentHour >= 12 && currentHour <= 14
                        ? 2
                        : currentHour > 14 && currentHour < 19
                            ? 2.1
                            : currentHour >= 19 && currentHour <= 21
                                ? 3
                                : 4;
            return currentDayId;
        }

        /// <summary>
        /// Gets the default times.
        /// </summary>
        /// <returns></returns>
        public static TimeModel GetDefaultTimes()
        {
            return new TimeModel
            {
                Morning = new TimeModelHelper
                {
                    Hour = 8,
                    Minute = 0
                },
                Afternoon = new TimeModelHelper
                {
                    Hour = 13,
                    Minute = 0
                },
                Night = new TimeModelHelper
                {
                    Hour = 20,
                    Minute = 0
                }
            };
        }
    }
}
